﻿using System.Linq;
using System.Runtime.Serialization;
using System.Xml.Serialization;

namespace VA.PPMS.ProviderData
{
    public partial class Providers
    {
        [XmlNamespaceDeclarations]
        public XmlSerializerNamespaces Xmlns
        {
            get
            {
                var ns = new XmlSerializerNamespaces();
                ns.Add("p", "https://ppms.DNS   /exchange/ccn/1.0");

                return ns;
            }
            set { /* needed for xml serialization */ }
        }

        public string InitialProviderId
        {
            get
            {
                if (Provider != null && Provider.Count > 0) return Provider[0].ProviderId;
                return string.Empty;
            }
        }

        [DataMember]
        public string TransactionId { get; set; }

        [DataMember]
        public string NetworkId { get; set; }

        [DataMember]
        public bool IsVaNetwork { get; set; }
    }

    [KnownType(typeof(Individual))]
    [KnownType(typeof(Organization))]
    public partial class Provider
    {
        public bool IsOrganization => Type != null && Type.Item is Organization;

        public Npi FirstNpi
        {
            get
            {
                // base type on first NPI type
                if (Npis != null && Npis.Item.Any())
                {
                    return Npis.Item[0];
                }

                return null;
            }
        }

        public string FirstNpiNumber
        {
            get
            {
                var npi = FirstNpi;
                return npi?.Number;
            }
        }

        public string ProviderNameDisplay
        {
            get
            {
                if (!IsOrganization)
                {
                    return IndividualName;
                }

                if (Type.Item is Organization obj) return obj.ProviderName;
                return string.Empty;
            }
        }

        public string IndividualName
        {
            get
            {
                if (Type.Item is Individual obj) return $"{obj.LastName}, {obj.FirstName}";
                return null;
            }
        }

        public bool IsModification => !string.IsNullOrEmpty(CorrelationId);
    }

    public partial class Address
    {
        public string CompositeId
        {
            get
            {
                var addressLine = $"{Address1} {Address2} {Address3}".Trim();
                return $"{addressLine}, {City}, {State}, {PostalCode}";
            }
        }
    }
}